GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[udpMoveProcessedEntryFromQueueToMails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[udpMoveProcessedEntryFromQueueToMails]
GO
CREATE PROCEDURE [dbo].[udpMoveProcessedEntryFromQueueToMails]
--=================================================
@id INT,
@MailSubject NVARCHAR(256),
@MailFrom NVARCHAR(256),
@MailTo NVARCHAR(256),
@MailBody NTEXT,
@ReservationID INT,
@errorMessage NVARCHAR(1000)
--=================================================
AS
BEGIN
    -- History:
    -- 28/07/2015: Benpn created for the 1st time (tfs 28149: Make sending emails more robust)
    -- End History
	if @ReservationID = 0
		Set @ReservationID = null

    SET NOCOUNT ON
    BEGIN TRY
    BEGIN TRANSACTION
    INSERT INTO 
        [dbo].[Mails]
        (
            [Created] ,
            [CreatedBy] ,
            [LastUpdated] ,
            [LastUpdatedBy] ,
            [Subject] ,
            [MailFrom] ,
            [MailTo] ,
            [Body] ,
            [SentDate] ,
            [SMTPErrorMessage] ,
            [ReservationID]					
        )
    VALUES  
        ( 
            GETUTCDATE(), -- ThinhTT 15/04/2012: #7677 - Times two hours off in RC - workflow view
            0 ,
            NULL ,
            0 ,
            @MailSubject ,
            @MailFrom ,
            @MailTo ,
            @MailBody ,
            GETUTCDATE() , -- ThinhTT 15/04/2012: #7677 - Times two hours off in RC - workflow view
            @errorMessage ,
            @ReservationID				
        )	
    DELETE FROM EmailQueues WHERE id  = @id --Delete from emailqueues
    COMMIT
    END TRY
    BEGIN CATCH
    IF @@TRANCOUNT > 0
	BEGIN
		SELECT ERROR_MESSAGE() AS ErrorMessage;
        ROLLBACK
		END
    END CATCH
END

GO
-- create procedure GetReservationBookingManagerCalendarView --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetReservationBookingManagerCalendarView]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetReservationBookingManagerCalendarView]
GO
CREATE procedure [dbo].[GetReservationBookingManagerCalendarView]
@startTime datetime = null,
@endTime datetime = null,
@groupId int = null,
@resourceIds nvarchar(max) = null,
@organizerMail nvarchar(max) = null
as
begin
-- split resource ids list string into table
declare @resourceIdsTbl table (id nvarchar(256))
insert into @resourceIdsTbl
select Item from udfSplitStringV2(@resourceIds, ',')
-- start select data
select 
	A.id,
	A.Guid,
	A.ResourceId,
	A.Subject,
	A.StartDate,
	A.EndDate,
	A.OrganizerEmail,
	A.OrganizerName,
	A.OriginalReservationId,
	A.IsActive,
	A.VRReservationId,
	A.ParentResourceIds
	from
	(
		-- select booking manager active reservation
		select distinct
			CONVERT(varchar, r.id) as id,
			r.[GUID] as [Guid],
			r.RessourceId as ResourceId,
			r.Subject,
			r.StartDate,
			r.EndDate,
			r.OrganizerEmail,
			r.OrganizerName,
			r.id as OriginalReservationId,
			(1 - ISNULL(bmm.InProcess, 0)) as IsActive,
			ISNULL(r.VRReservationId, 0) AS VRReservationId,
			[dbo].[fn_Resource_GetVRStringIds](r.RessourceId) as ParentResourceIds
		from Reservations r
		left join ChildResources rc on r.RessourceId = rc.ChildResourceId
		left join @resourceIdsTbl rbl on r.RessourceId = rbl.id
		left join (
				select bm.GlobalId, max(CASE WHEN bm.IsProcessing = 0 THEN 0 ELSE 1 END) as InProcess from BookingManagerMessage bm
		group by GlobalId
		) bmm on r.GlobalID = bmm.GlobalId
		--base condition
		where (r.Active <> 0 OR ISNULL(r.VRReservationId, 0) <> 0)
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--condition for recurring
			and (r.ParentReservationId is null or r.ParentReservationId <> 0)
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		union all
		-- select booking manager inactive reservation
		select distinct
			B.id,
			'' as [Guid],
			B.ResourceId as ResourceId,
			B.Subject,
			B.StartDate,
			B.EndDate,
			B.OrganizerEmail,
			B.OrganizerName,
			B.OriginalReservationId,
			0 as IsActive,
			B.VRReservationId,
			B.ParentResourceIds
		from
		(
			select 
				ROW_NUMBER() over (partition by r.GlobalID, bm.ResourceId order by r.id asc) as num,
				ISNULL(CAST(r.id as varchar(10)),'')+'-'+ISNULL(CAST(bm.ResourceId as varchar(10)),'') as id,
				bm.ResourceId as ResourceId,
				r.Subject,
				bm.NewStartDate as StartDate,
				bm.NewEndDate as EndDate,
				r.OrganizerEmail,
				r.OrganizerName,
				r.id as OriginalReservationId,
				CASE WHEN r.VRReservationId is null THEN -1 ELSE r.VRReservationId END AS VRReservationId,
				[dbo].[fn_Resource_GetVRStringIds](bm.ResourceId) as ParentResourceIds
			from BookingManagerMessage bm
			inner join Reservations r on bm.GlobalId = r.GlobalID 
			left join @resourceIdsTbl rbl on bm.ResourceId = rbl.id
			where bm.IsProcessing = 1
				and bm.IsNewResource = 1
				--condition for recurring
				and (r.ParentReservationId is null or r.ParentReservationId <> 0)
				--additional condition
				AND r.StartDate >= Dateadd(day, -20, @startTime) 
				--base condition
				AND r.Active <> 0
				AND r.isrecurring <> 2 
				AND r.BusyStatus ='BUSY'
				--current date condition
				AND bm.NewStartDate < @endTime 
				AND bm.NewEndDate > @startTime
				--booking manager active condition
				AND r.BookingManagerActive = 0
				AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
				AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		)B where B.num = 1
	) A
end
GO
DECLARE @MaxId int
SELECT @MaxId =  max(id) +  1 from Translations
DECLARE @ToolBarId INT
IF EXISTS (SELECT 1 id FROM  ToolbarFunctions WHERE FunctionName = '@ImportVisitor')
  BEGIN
  SELECT @ToolBarId = id FROM  ToolbarFunctions WHERE FunctionName = '@ImportVisitor'
  END
ELSE
	select @ToolBarId =  Max(id) from ToolbarFunctions
	IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@ImportVisitor')
	BEGIN
	 SET @ToolBarId = @ToolBarId +1
	INSERT INTO [dbo].[ToolbarFunctions] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [FunctionName], [Caption], [DescriptionShort], [requestConfirmation], [iconRef], [ACLtype], [IconRef2007]) VALUES (@ToolBarId, NULL, NULL, NULL, NULL, N'@ImportVisitor', N'Import Visitors', 'Import visitors from Excel file.', NULL, '../images/Excel.gif', 4, '../images/Excel.gif')
END
 --da
 SET @MaxId = @MaxId +1 
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'da' AND ObjectName = 'ToolbarFunctions') 
 INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'da','Importer Gæster','Importer gæster fra Excel regneark')

-- De
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'de' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'de','Besucher importieren','Besucher aus einer Excel-Tabelle importieren.')
-- es
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'es' AND ObjectName = 'ToolbarFunctions')

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'es','Importar visitantes','Importar visitantes desde hoja de cálculo Excel')
-- Fi
SET @MaxId = @MaxId +1 
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'fi' AND ObjectName = 'ToolbarFunctions')

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'fi','Tuo vierailijoita','Tuo vierailijoita Excel-taulukosta')
-- Fr
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'fr' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'fr','Importer des visiteurs','Importer des visiteurs depuis Excel')
--it
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'it' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'it','Importa Visitatori','Importa visitatori da foglio Excel')
--Ja
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ja' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ja',N'ビジタのインポート',N'Excelスプレッドシートからビジタをインポートする')
--ko
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ko' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ko',N'참가자 가져오기',N'Excel 스프레드시트로부터 참가자 가져오기')
--nb
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'nb',N'Importer besøkende',N'Importer besøkende fra Excel-regneark')
--nl
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'nl' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'nl',N'Bezoekers importeren',N'Bezoekers importeren uit Excel-werkblad')
--pt
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'pt' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'pt',N'Importar visitantes',N'Importar visitantes da folha de cálculo do Excel')
--ru
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ru' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ru',N'Импортировать посетителей',N'Импортировать посетителей из электронной таблицы Excel')
--sv
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'sv' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'sv',N'Importera besökare',N'Importera besökare från Excel-kalkylblad')
--zh-CN
 
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'zh' AND ObjectName = 'ToolbarFunctions') 

INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'zh',N'导入访客',N'从 Excel 电子表格中导入访客')

-- @DowloadTemplate
IF EXISTS (SELECT 1 id FROM  ToolbarFunctions WHERE FunctionName = '@DowloadTemplate')
  BEGIN
  SELECT @ToolBarId = id FROM  ToolbarFunctions WHERE FunctionName = '@DowloadTemplate'
  END
ELSE
    select @ToolBarId =  Max(id) from ToolbarFunctions
	IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@DowloadTemplate')
	BEGIN
	 SET @ToolBarId = @ToolBarId +1
	INSERT INTO [dbo].[ToolbarFunctions] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [FunctionName], [Caption], [DescriptionShort], [requestConfirmation], [iconRef], [ACLtype], [IconRef2007]) VALUES (@ToolBarId, NULL, NULL, NULL, NULL, N'@DowloadTemplate', N'Download Skabelon', 'Download Skabelon.', NULL, '../images/Excel.gif', 4, '../images/Excel.gif')

END

-- da
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'da' AND ObjectName = 'ToolbarFunctions')  
  INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'da','Download Skabelon','Download Skabelon')
-- de
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'de' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'de','Vorlage herunterladen','Vorlage herunterladen')
-- es
SET @MaxId = @MaxId +1 
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'es' AND ObjectName = 'ToolbarFunctions')
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'es','Descargar plantilla','Descargar plantilla')
-- Fi
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'fi' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'fi','Lataa malli','Lataa malli')

--Fr
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'fr' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'fr','Télécharger le modèle','Télécharger le modèle')
--it
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'it' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'it','Scarica modello','Scarica modello')
--Ja
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ja' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ja',N'テンプレートのダウンロード',N'テンプレートのダウンロード')
--ko
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ko' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ko',N'템플릿 다운로드',N'템플릿 다운로드')
--nb
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'nb',N'Last ned mal',N'Last ned mal')
--nl
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'nl' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'nl',N'Sjabloon downloaden',N'Sjabloon downloaden')
--pt
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'pt' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'pt',N'Transferir modelo',N'Transferir modelo')
--ru
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ru' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ru',N'Загрузить шаблон',N'Загрузить шаблон')
--sv
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'sv' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'sv',N'Ladda ned mall',N'Ladda ned mall')
--zh-CN
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'zh' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'zh',N'下载模板',N'下载模板')


--BookingManager
SELECT @MaxId =   @MaxId +1
DECLARE @TreeId INT
SELECT @TreeId = id FROM  Tree WHERE [Key] = 'BookingManager'

IF EXISTS (SELECT 1 id FROM  Tree WHERE [Key] = 'BookingManager')
  BEGIN
  SET @TreeId =(SELECT TOP 1 id FROM  Tree WHERE [key] = 'BookingManager')
  END
ELSE	
	BEGIN	
-----insert into URLMapping-----
	declare @MaxFunctionId int = (select MAX(FunctionId) from URLMapping)
	declare @BookingManagerFunctionId int = @MaxFunctionId + 1
	insert into URLMapping(FunctionId,Created,LastUpdated,FunctionHandler) values(@BookingManagerFunctionId,GETUTCDATE(),GETUTCDATE(),'BookingManager.aspx')
-----insert into Tree-----
	declare @MaxTreeNodeId int = (select top 1 LastID from TableKeys where TableName = 'Tree')
	declare @BookingManagerNodeId int = @MaxTreeNodeId + 1
	declare @ParentNodeId int = (select top 1 id from Tree where [Key] = '@DAILYTASKS')
	insert into Tree(id,Created,LastUpdated,parentNodeId,[Key],Caption,SortOrder,IsApplicationNode,FunctionId,IconKey,CustomCalendarId,NodeType)
	values(@BookingManagerNodeId,GETUTCDATE(),GETUTCDATE(),@ParentNodeId,'BookingManager','Booking Manager',4,1,@BookingManagerFunctionId,'Orders',1,0)
-----insert into acl-----
	insert into acl(Created,LastUpdated,RoleId,TreeNodeId,actionId,Allow) 
	values(GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,1,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,2,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,3,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,4,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,5,1)
-----update TableKeys------------------
    Update TableKeys set LastID = @BookingManagerNodeId where TableName = 'Tree'
	SET @TreeId = (SELECT  LastID FROM  TableKeys where TableName = 'Tree')
end

--da
SET @MaxId = @MaxId+1 
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'da' AND ObjectName = 'Tree') 
 INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'da','Booking Administration','Booking Administration')
	
-- de 
SET @MaxId = @MaxId +1  
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'de' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'de','Buchungsmanager','Buchungsmanager')
-- es
SET @MaxId = @MaxId +1 
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'es' AND ObjectName = 'Tree')
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'es','Administrador de reservas','Administrador de reservas')
-- Fi
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'fi' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'fi','Varausten hallinta','Varausten hallinta')

--Fr
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'fr' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'fr','Gestionnaire de réservations','Gestionnaire de réservations')
--it
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'it' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'it','Manager prenotazioni','Manager prenotazioni')
--Ja
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'ja' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'ja',N'ブッキングマネージャ',N'ブッキングマネージャ')
--ko
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'ko' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'ko',N'예약 관리자',N'예약 관리자')

--nb
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'nb' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'nb',N'Booking-ansvarlig',N'Booking-ansvarlig')
--nl
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'nl' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'nl',N'Reserveringsbeheer',N'Reserveringsbeheer')
--pt
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'pt' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'pt',N'Gestor de reserva',N'Gestor de reserva')
--ru
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'ru' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'ru',N'Менеджер по бронированию',N'Менеджер по бронированию')
--sv
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'sv' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'sv',N'Bokningshanterare',N'Bokningshanterare')
--zh-CN
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @TreeId AND [Language] = 'zh' AND ObjectName = 'Tree') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'Tree',@TreeId,'zh',N'预订管理器',N'预订管理器')

-- Filter
IF EXISTS (SELECT 1 id FROM  ToolbarFunctions WHERE FunctionName = '@ClearFilter')
  BEGIN
  SELECT @ToolBarId = id FROM  ToolbarFunctions WHERE FunctionName = '@ClearFilter'
  END
ELSE
	SELECT @ToolBarId =  Max(id) FROM ToolbarFunctions	
	IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@ClearFilter')
	BEGIN
	 SET @ToolBarId = @ToolBarId +1
	insert into ToolbarFunctions(id,FunctionName,Caption,DescriptionShort,iconRef) values(@ToolBarId,'@ClearFilter','Clear Filter','Reset all filters for this view','../images/Filter.gif')
END
--da
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'da' AND ObjectName = 'ToolbarFunctions') 
 INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'da','Rens Filter','Nulstil alle filtre for denne Visning.')
-- de
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'de' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'de','Filter zurücksetzen','Alle Filter für diese Ansicht zurücksetzen.')
-- es
SET @MaxId = @MaxId +1 
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'es' AND ObjectName = 'ToolbarFunctions')
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'es','Borrar filtro','Restablezca todos los filtros de esta vista.')
-- Fi
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'fi' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'fi','Tyhjennä suodatin','Tyhjennä kaikki tämän näkymän suodattimet.')

--Fr
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'fr' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'fr','Supprimer le filtre','Réinitialisez tous les filtres de cette vue.')
--it
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'it' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'it','Cancella filtro','Reimposta tutti i filtri per questa visualizzazione.')
--Ja
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ja' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ja',N'フィルタのクリア',N'このビューのすべてのフィルタをリセットします。')
--ko
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ko' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ko',N'필터 지우기',N'이 보기에 대한 모든 필터를 초기화합니다.')
--nb
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'nb',N'Tøm filter',N'Tilbakestill alle filtre for denne visningen.')
--nl
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'nl' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'nl',N'Filter wissen',N'Reset alle filters voor deze weergave.')
--pt
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'pt' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'pt',N'Limpar filtro',N'Reponha todos os filtros para esta vista.')
--ru
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'ru' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'ru',N'Очистить фильтр',N'Сбросить все фильтры для данного просмотра.')
--sv
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'sv' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'sv',N'Rensa filter',N'Återställ alla filter för den här vyn.')
--zh-CN
SET @MaxId = @MaxId +1
IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = @ToolBarId AND [Language] = 'zh' AND ObjectName = 'ToolbarFunctions') 
INSERT INTO [dbo].[Translations]([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES(@MaxId,'ToolbarFunctions',@ToolBarId,'zh',N'清除筛选器',N'重置此视图的所有筛选器。')
GO
 UPDATE [DBVersion] SET [Value] = '3.8.0004.0047' WHERE [Property]='dbVersion'
GO